
' MODULE:    SPELLCHK.BAS
'
' PURPOSE:   Declarations for the SpellChecker .DLL
'
' Copyright Graham Plowman, 1996

Option Explicit

' Definitions
Global Const MAXWORDLEN = 64

' Error number constants
Global Const ER_OK = 0
Global Const ER_MEMALLOCFAIL = 1
Global Const ER_UNRECOGNISEDDICT = 2
Global Const ER_UNRECOGNISEDVER = 3
Global Const ER_SOURCEFILEERROR = 4
Global Const ER_DICTIONARYFULL = 5
Global Const ER_DICTLOADERROR = 6
Global Const ER_IGNOREALLBUFFULL = 7
Global Const ER_NOTINITIALISED = 8
Global Const ER_CANCELLED = 9
Global Const ER_LINEFULL = 10
Global Const ER_NODISKSPACE = 11
Global Const ER_TEMPCREATEERROR = 12
Global Const ER_INVALIDLICENSE = 13
Global Const ER_LICENSEEXPIRED = 14
Global Const ER_INTEGRITYERROR = 15
Global Const ER_TARGETERROR = 16

' Function declarations
Declare Function SpellLoadDictionary Lib "spellchk.dll" () As Integer
Declare Sub SpellUnloadDictionary Lib "spellchk.dll" ()

Declare Sub SpellResetIgnoreAllBuffer Lib "spellchk.dll" ()

Declare Function SpellCheckBuffer Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal lpBuffer As String, ByVal cbBufLen As Integer) As Integer
Declare Function SpellCheckFile Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal lpFileName As String) As Integer
Declare Function SpellCheckEdit Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal hEdit As Integer) As Integer
Declare Function SpellCheckWord Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal lpWord As String, ByVal lpNewWord As String) As Integer

Declare Sub SpellCheckError Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal nError As Integer)
Declare Sub SpellCheckError Lib "spellchk.dll" (ByVal hWnd As Integer, ByVal nError As Integer)
Declare Sub SpellMessage Lib "spellchk.dll" (ByVal nError As Integer, lpMsg As String)
Declare Sub SpellSetup Lib "spellchk.dll" (ByVal hWnd As Integer)
Declare Sub SpellAbout Lib "spellchk.dll" (ByVal hWnd As Integer)

Declare Function SpellSetLicense Lib "spellchk.dll" (ByVal lpLicense As String)

Declare Function SpellImportWords Lib "spellchk.dll" (ByVal lpFileName As String) As Integer
Declare Function SpellExportWords Lib "spellchk.dll" (ByVal lpFileName As String) As Integer

